/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.sim.api.VWScenarioOrderType;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import java.io.Serializable;

public final class VWScenarioPriorityField
implements Serializable,
Cloneable {
    private String m_name = null;
    private int m_index = 0;
    private int m_type;
    private int m_order;

    protected VWScenarioPriorityField(String name, int fieldType, int orderType, int index) throws VWException {
        this.setName(name);
        this.setFieldType(fieldType);
        this.setOrderType(orderType);
        this.setIndex(index);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) throws VWException {
        if (name == null) {
            throw new VWException("sim.api.VWScenarioPriorityField.NullNameParameter", "The name parameter can not be null.");
        }
        this.m_name = name;
    }

    public int getFieldType() {
        return this.m_type;
    }

    public void setFieldType(int type) throws VWException {
        if (!VWFieldType.isValid(type)) {
            throw new VWException("sim.api.VWScenarioPriorityField.InvalidFieldType", "The type passed is {0}, which is not a valid VWFieldType.", String.valueOf(type));
        }
        this.m_type = type;
    }

    public int getOrderType() {
        return this.m_order;
    }

    public void setOrderType(int orderType) throws VWException {
        if (!VWScenarioOrderType.isValid(orderType)) {
            throw new VWException("sim.api.VWScenarioPriorityField.InvalidOrderType", "The type passed is {0}, which is not a valid order type.", String.valueOf(orderType));
        }
        this.m_order = orderType;
    }

    public String toString() {
        return this.getName();
    }

    protected static String typeToString(int fieldType) throws VWException {
        switch (fieldType) {
            case 1: {
                return "int";
            }
            case 2: {
                return "string";
            }
            case 4: {
                return "boolean";
            }
            case 8: {
                return "float";
            }
            case 16: {
                return "time";
            }
            case 32: {
                return "attachment";
            }
            case 64: {
                return "participant";
            }
        }
        throw new VWException("vw.api.VWFieldTypeBadInteger", "Integer form of the field type is invalid: {0}", String.valueOf(fieldType));
    }

    protected static int stringToType(String fieldType) throws VWException {
        if (fieldType.equals("int")) {
            return 1;
        }
        if (fieldType.equals("string")) {
            return 2;
        }
        if (fieldType.equals("boolean")) {
            return 4;
        }
        if (fieldType.equals("float")) {
            return 8;
        }
        if (fieldType.equals("time")) {
            return 16;
        }
        if (fieldType.equals("attachment")) {
            return 32;
        }
        if (fieldType.equals("participant")) {
            return 64;
        }
        throw new VWException("vw.api.VWFieldTypeBadString", "String form of the field type is invalid: {0}", fieldType);
    }

    protected int getIndex() {
        return this.m_index;
    }

    protected void setIndex(int index) {
        this.m_index = index;
    }

    protected Object clone() {
        VWScenarioPriorityField clone = null;
        try {
            clone = (VWScenarioPriorityField)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }
}

